' Started....1/01/15
' Microcontroller used:  Microchip Technology PIC16F88
'                        microchip.com
' PicBasic Pro Code: micro-Engineering Labs, Inc.
'                    melabs.com 

'--------Program Desciption--------

' The program uses one of the analog-to-digital
' converters,(AN4), to measure the voltage 
' on the center pin of a potentiometer (an analog signal).
' It then converts the analog voltage into an 10-bit
' digital value (0 to 1023), divides the answer by 10 and displays
'the result on an LCD. If the resistance is below 10E then extra current is fed 
'into the resistor  to obtain better accuracy

'
'
' 
   #CONFIG
 __CONFIG    _CONFIG1, _CP_OFF & _CCP1_RB0 & _DEBUG_OFF & _WRT_PROTECT_OFF & _CPD_OFF & _LVP_OFF & _BODEN_OFF & _MCLR_ON & _PWRTE_ON & _WDT_OFF & _INTRC_IO
 #ENDCONFIG
 
 
 
    define LCD_DREG PORTB'PORTB is LCD data PORT
    define LCD_DBIT 0 'PORTB.0 is the data lowest significanr bit  
    define LCD_RSREG PORTB   ' PORTB - RS port   
    define LCD_RSBIT 4       ' RS bit connects to PORTB.4
    define LCD_EREG PORTB ' PORTB E PORT
    define LCD_EBIT 5    ' E to RB5
    Define LCD_BITS 4 '4 data lines used
    define LCD_LINES 2  'LCD display has 2 lines
    Define LCD_COMMANDUS 1500 'Set data delay time to 1.5ms
    define LCD_DATAUS 44 'Set data delay to 44 micro second
    
    Define  ADC_BITS     10    ' Set number of bits in result
	Define  ADC_CLOCK    3     ' Set clock source (3=rc)
	Define  ADC_SAMPLEUS 50    ' Set sampling time in uS
	 
       
'------------Variables-------------
     
     x  var word           ' Byte for potentiometer input 
     RES_INT var word  ' whole number value of input voltage  ie 4 for 4.32 Volts
     res_frac var word 'fraction part of input voltage  ie for 0.32 for 4.32 Volts
     
     
'----------Initialization----------

    ANSEL = %00010000  ' Leaves AN4 in analog mode, but                 
                       ' changes other analog bits to digital.
    TRISB = %00000000 ' all outputs                   
    TRISA = %00111110 'RA1,RA2, RA3, RA4, RA5 inputs rest outputs                  
   ADCON1 =  %10110000  ' Bit 7 Right justifies 10-bit value of x
                        ' in 16-bit WORD. Adds "0" in the
                        ' 6 Most Significant bits of the Word,
                        ' shifting the 10-bit value of x to
                        ' the right. This changes the LCD
                        ' values to 0 - 1023. Bit 4 and bit 5
                        'make RA2 Vref- and RA3 vre+
'    

'
                                
    OSCCON = $60	            ' Sets the internal oscillator in the
                                ' 16F88 to 4 MHz   	    
    
'-------------Main Code------------

pause 500  ' Pause to allow LCD to setup
display:


'LCDout $FE,$01
X = 0
PORTB.7 = 1
 adcin 4, X
 If X > 10  then goto ResH
 if X <= 10 then goto ResL
 
 





ResH:
adcin 4, x  'Read the value of the analogue input voltage and stores it as a 10bit word in X
if  X >1020   then goto over

RES_INT = X /10 'divide X by 10. As it is binary number you don't get the decimal remainder in
'the answer, only the interger
res_frac = X//100  ' divide x by 10 which gives the remainder. To convert remainder to a
'decimal you need to divide it by a further 10
LCDOUT $FE,$01  'clear display
LCDOUT $FE,$80  ' goto start of first line

LCDout DEC RES_INT, ".", dec1 res_frac , " OHM"
pause 400
goto display

over:
LCDOUT $FE,$01  'clear display
LCDOUT $FE,$80  ' goto start of first line

lcdout "OVER RANGE"
pause 100
goto display



ResL:
PortB.7 = 0 'mosfet on
adcin 4, x  'Read the value of the analogue input voltage ans stores it as a 10bit word in X


res_INT = X/100
res_frac = X//1000
LCDOUT $FE,$01  'clear display
LCDOUT $FE,$80  ' goto start of first line

LCDout  DEC RES_INT, ".", dec2 res_frac , " OHM"
pause 400
goto display
 
 


 end

	

